/**
*
* MD Gallery v1 [build1.0]
* Copyright (c) 2007 D. Molanphy, Molanphy Design
* 
* This software may be used in personal and commercial projects provided the 
* source code retains the above copyright notice.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT 
* NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. 
* IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
* WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
* SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*
*
*/

var firstCopyBuild:Boolean = false;

//==============================================================================================
//---- MINIMAL CSS FOR ANCHOR LINKS
//==============================================================================================
import TextField.StyleSheet;

var my_styleSheet:StyleSheet = new StyleSheet();
my_styleSheet.onLoad = function(success:Boolean) {
    if (!success) {
       throwError("Error loading CSS");
    }
};

//==============================================================================================
//---- FUNCTION TO PLACE COPY ON MAIN PAGE
//==============================================================================================
function placeCopy():Void {
	// load CSS
	my_styleSheet.load(cssPath);

	if (!gallery_mc.copy_mc) {
		gallery_mc.attachMovie("mc.copy", "copy_mc", gallery_mc.getNextHighestDepth());
	}

	var title:String 						= gallery_obj.gallery[galleryDisplayed].name;
	var description:String 					= gallery_obj.gallery[galleryDisplayed].description;
	
	var titleIndex:Number 					= title.indexOf("|");
	var titleGreen_fmt:TextFormat 			= new TextFormat();
	titleGreen_fmt.color 					= linkColor;

	gallery_mc.copy_mc.bodyCopy_mc.title_txt.htmlText 		= title;
	gallery_mc.copy_mc.bodyCopy_mc.copy_txt.autoSize		= true;
	gallery_mc.copy_mc.bodyCopy_mc.copy_txt.styleSheet		= my_styleSheet;
	gallery_mc.copy_mc.bodyCopy_mc.copy_txt.htmlText 		= description;
	gallery_mc.copy_mc.copyright_mc.copyright_txt.htmlText 	= copyright;

	// alpha
	gallery_mc.copy_mc.bodyCopy_mc._alpha = 0;
	gallery_mc.copy_mc.bodyCopy_mc.alphaTo(100, 1, 'easeInOutSine', .25);

	// set vr & move copyright
	var textH:Number = gallery_mc.copy_mc.bodyCopy_mc.copy_txt.textHeight + 100;
	gallery_mc.copy_mc.vr_mask.tween("_height", textH, 1, 'easeInOutExpo');
	gallery_mc.copy_mc.copyright_mc.tween("_y", gallery_mc.copy_mc.bodyCopy_mc.copy_txt.textHeight + 80, 1, 'easeInOutExpo');
	
	
	if (titleIndex != -1) {
		gallery_mc.copy_mc.bodyCopy_mc.title_txt.setTextFormat(titleIndex + 1, gallery_mc.copy_mc.bodyCopy_mc.title_txt.length, titleGreen_fmt);
	}
	
	if (firstCopyBuild == false) {
		var galleryW:Number 				= gallery_mc.mask_mc._width;
		var galleryY:Number 				= gallery_mc.mask_mc._height;

		gallery_mc.copy_mc._alpha 			= 0;
		gallery_mc.copy_mc._x 				= 0;
		gallery_mc.copy_mc._y 				= galleryY + 10;
		gallery_mc.copy_mc.hr_mask._width 	= galleryW;
	
		gallery_mc.copy_mc.alphaTo(100, 1, 'easeInOutSine');
		repositionSite();
		firstCopyBuild = true;
	}
	
	
	
	// emailMask
	gallery_mc.copy_mc.email_txt.text = userEmail;
	
	// buttons
	gallery_mc.copy_mc.mail_mc.onRollOver = function():Void {
		this.colorTo(linkColor, 0);
		gallery_mc.copy_mc.emailMask_mc.tween(["_width", "_x"], [350, 80], 1, 'easeInSine');
	}

	gallery_mc.copy_mc.mail_mc.onRollOut = function():Void {
		this.colorTo(null, 0);
		gallery_mc.copy_mc.emailMask_mc.tween(["_width", "_x"], [30, 395], 1, 'easeInSine');
	}

	gallery_mc.copy_mc.mail_mc.onRelease = function():Void {
		mainTL.getURL("mailto:" + userEmail);
	}
	
	
};

//==============================================================================================
//---- FUNCTION TO PLACE COPY ON LARGE IMAGES
//==============================================================================================
function populateCopy(image:MovieClip, holder:MovieClip, which:Number, delay):Void {
	// attach it
	var copy:MovieClip 			= image.attachMovie("large.description", "copy_mc", image.getNextHighestDepth(), {_alpha:0});
	copy.desc_txt.autoSize 		= true; 
	copy.bground_mc._width 		= holder._width;
	
	// populate it
	copy.title_txt.htmlText = library_obj.image[which].name;
	copy.desc_txt.htmlText 	= library_obj.image[which].desc;

	// size it and place it
	var tHeight:Number 		= Math.round(copy.desc_txt.textHeight + copy.title_txt.textHeight);
	copy.title_txt._width 	= copy.desc_txt._width = Math.round(holder._width * .85);
	copy.bground_mc._height = copy._height + 10;
	copy._x 				= 0 - holder._width/2;
	copy._y 				= holder._height/2 - copy._height;
	
	// toggle visibility
	holder._alpha = 0;
	holder.alphaTo(100, 1, 'easeInOutSine', .5);
	image._visible = true;
	
	// roll over function
	holder.onRollOver = function():Void {
		copy.alphaTo(85, 1, 'easeInOutSine', delay);
		delay = 0;
	}
	
	holder.onRollOut = function():Void {
		copy.alphaTo(0, 1, 'easeInOutSine');
	}
	
	// close action
	holder.onRelease = holder.onReleaseOutside = function():Void {
		mainTL.bgroundBox_mc.alphaTo(0, 1, 'easeInOutSine', null, {func:destroy, args:[mainTL.bgroundBox_mc]});
		image.removeMovieClip();
		enableThumbs(true);
		enableButtons(true);
	}

};

